#!/bin/bash

# setting the right directories
BASEDIR="$( cd "$(dirname "$0")"; pwd )"
RESOURCESDIR="$( cd "$BASEDIR/../Resources"; pwd )"
EXTRADIR="$( cd "$BASEDIR/../Extra"; pwd )"

# setting full path to the quake2 binary
BIN="$RESOURCESDIR/quake2"

# setting the full path to the cocoaDialog-binary (in this case its in the Extra-Directory)
CD="$EXTRADIR/cocoaDialog.app/Contents/MacOS/cocoaDialog"

# self explaining me thinks...
W_TITLE="Quake 2 Launcher"
W_HEIGHT=200
W_TEXT="Choose game to start"
W_ICON="$RESOURCESDIR/quake2.icns"
W_ICON_SIZE=128
W_START="Start"
W_CANCEL="Cancel"

# text for items to be used as radio buttons
Q2="Quake 2"
XA="The Reckoning"
RO="Ground Zero"
US="add command-line options"


# check whether an add-on is installed or not, or check if quake2-data is installed
if [ -e "$RESOURCESDIR/baseq2/pak0.pak" ] && [ -e "$RESOURCESDIR/xatrix/pak0.pak" ] && [ -e "$RESOURCESDIR/rogue/pak0.pak" ]; then
        game_available="ALL"
elif [ -e "$RESOURCESDIR/baseq2/pak0.pak" ] && [ -e "$RESOURCESDIR/xatrix/pak0.pak" ]; then
        game_available="Q2+XA"
elif [ -e "$RESOURCESDIR/baseq2/pak0.pak" ] && [ -e "$RESOURCESDIR/rogue/pak0.pak" ]; then
        game_available="Q2+RO"
elif [ -e "$RESOURCESDIR/baseq2/pak0.pak" ]; then
        game_available="Q2only"
fi


case "$game_available" in
"Q2only")  rv=`"$CD" radio --title "$W_TITLE" --button1 "$W_START" --button2 "$W_CANCEL" \
			--label "$W_TEXT" --selected 0 --icon-file "$W_ICON" --icon-size "$W_ICON_SIZE" --string-output \
			--items "$Q2" "$US"`
           ;;
"Q2+XA")   rv=`"$CD" radio --title "$W_TITLE" --button1 "$W_START" --button2 "$W_CANCEL" \
			--label "$W_TEXT" --selected 0 --icon-file "$W_ICON" --icon-size "$W_ICON_SIZE" --string-output \
			--items "$Q2" "$XA" "$US"`
           ;;
"Q2+RO")   rv=`"$CD" radio --title "$W_TITLE" --button1 "$W_START" --button2 "$W_CANCEL" \
			--label "$W_TEXT" --selected 0 --icon-file "$W_ICON" --icon-size "$W_ICON_SIZE" --string-output \
			--items "$Q2" "$RO" "$US"`
           ;;
"ALL")     rv=`"$CD" radio --title "$W_TITLE" --button1 "$W_START" --button2 "$W_CANCEL" \
			--label "$W_TEXT" --selected 0 --icon-file "$W_ICON" --icon-size "$W_ICON_SIZE" --string-output \
			--items "$Q2" "$XA" "$RO" "$US"`
           ;;
*)	   rv=`"$CD" msgbox --title "$W_TITLE" --no-newline \
			--icon-file "$W_ICON" --icon-size "$W_ICON_SIZE" \
			--text "Quake 2 game data not found!" \
			--informative-text "Please copy your game data files to the Resources-folder of this App" \
			--button1 "open Resources folder" --button2 "Cancel"`
	   if [ "$rv" == 1 ]
	   then
		open "$RESOURCESDIR"
	   fi
   	   exit
   	   ;;
esac

# cocoaDiolog radio returns an '\n'-delimeted string - first part is what button is pressed
# and the second part wich radio-button was chosen
# -> parse the output in two variables
read BUTTON_PRESSED ACTION_CHOOSED <<<$(echo $rv)

# cancel pressed - exiting
if [[ "$BUTTON_PRESSED" = "$W_CANCEL" ]]
then
	echo "canceling"
	exit
fi

# setting the arguments for the binary
case "$ACTION_CHOOSED" in
"$Q2")  PARAMS=""
		;;
"$XA")	PARAMS="+set game xatrix"
		;;
"$RO")	PARAMS="+set game rogue"
        ;;
"$US")	PARAMS=`"$CD" standard-inputbox --title "$W_TITLE" --no-cancel \
				--informative-text "$US" --icon-file "$W_ICON" --icon-size "$W_ICON_SIZE"`
        ;;
*)		exit
        ;;
esac

# Start Quake 2 with parameters
cd "$RESOURCESDIR"
"$BIN" $PARAMS
